/*
 * Decompiled with CFR 0.152.
 */
public class PitchClassSet {
    private int nElementosSet;
    private int setTipo;
    private int[] notas;
    private static final int SETSDETRES = 0;
    private static final int SETSDECUATRO = 12;
    private static final int SETSDECINCO = 41;
    private static final int SETSDESEIS = 79;
    private static final int SETSDESIETE = 129;
    private static final int SETSDEOCHO = 167;
    private static final int SETSDENUEVE = 196;
    private static final int LASTSET = 208;
    private static final int[] arrayNElementos = new int[]{3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9};
    private static final int[] arraySetTipo = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12};
    private static final String[] vi = new String[]{"210000", "111000", "101100", "100110", "100011", "020100", "011010", "010101", "010020", "002001", "001110", "000300", "321000", "221100", "212100", "211110", "210111", "210021", "201210", "200121", "200022", "122010", "121110", "112101", "112011", "111120", "111111", "110121", "102210", "102111", "101310", "101220", "030201", "021120", "021030", "020301", "020202", "012120", "012111", "004002", "111111", "432100", "332110", "322210", "322111", "321121", "311221", "310132", "232201", "231211", "223111", "222220", "222121", "221311", "221131", "220222", "213211", "212320", "212221", "212122", "211231", "202420", "202321", "132130", "131221", "123121", "122311", "122230", "122212", "122131", "121321", "114112", "113221", "040402", "032221", "032140", "222121", "212320", "212221", "543210", "443211", "433221", "432321", "422232", "421242", "420243", "343230", "342231", "333321", "333231", "332232", "324222", "323430", "323421", "322431", "322332", "322242", "313431", "303630", "242412", "241422", "234222", "233331", "233241", "232341", "225222", "224322", "224232", "224223", "223431", "143250", "143241", "142422", "060603", "433221", "432321", "421242", "333321", "333231", "332232", "324222", "322332", "313431", "234222", "233331", "233241", "232341", "224322", "224232", "654321", "554331", "544431", "544332", "543342", "533442", "532353", "454422", "453432", "445332", "444441", "444342", "443532", "443352", "442443", "435432", "434541", "434442", "434343", "433452", "424641", "424542", "354351", "353442", "345342", "344532", "344451", "344433", "344352", "343542", "336333", "335442", "262623", "254442", "254361", "444342", "434541", "434442", "765442", "665542", "656542", "655552", "654553", "654463", "645652", "644563", "644464", "566452", "565552", "556543", "556453", "555562", "555553", "554563", "546652", "546553", "545752", "545662", "474643", "465562", "465472", "464743", "464644", "456562", "456553", "448444", "555553", "876663", "777663", "767763", "766773", "766674", "686763", "677673", "676764", "676683", "668664", "667773", "666963"};
    private static final int[][] fp = new int[][]{{0, 1, 2}, {0, 1, 3}, {0, 1, 4}, {0, 1, 5}, {0, 1, 6}, {0, 2, 4}, {0, 2, 5}, {0, 2, 6}, {0, 2, 7}, {0, 3, 6}, {0, 3, 7}, {0, 4, 8}, {0, 1, 2, 3}, {0, 1, 2, 4}, {0, 1, 3, 4}, {0, 1, 2, 5}, {0, 1, 2, 6}, {0, 1, 2, 7}, {0, 1, 4, 5}, {0, 1, 5, 6}, {0, 1, 6, 7}, {0, 2, 3, 5}, {0, 1, 3, 5}, {0, 2, 3, 6}, {0, 1, 3, 6}, {0, 2, 3, 7}, {0, 1, 4, 6}, {0, 1, 5, 7}, {0, 3, 4, 7}, {0, 1, 4, 7}, {0, 1, 4, 8}, {0, 1, 5, 8}, {0, 2, 4, 6}, {0, 2, 4, 7}, {0, 2, 5, 7}, {0, 2, 4, 8}, {0, 2, 6, 8}, {0, 3, 5, 8}, {0, 2, 5, 8}, {0, 3, 6, 9}, {0, 1, 3, 7}, {0, 1, 2, 3, 4}, {0, 1, 2, 3, 5}, {0, 1, 2, 4, 5}, {0, 1, 2, 3, 6}, {0, 1, 2, 3, 7}, {0, 1, 2, 5, 6}, {0, 1, 2, 6, 7}, {0, 2, 3, 4, 6}, {0, 1, 2, 4, 6}, {0, 1, 3, 4, 6}, {0, 2, 3, 4, 7}, {0, 1, 3, 5, 6}, {0, 1, 2, 4, 8}, {0, 1, 2, 5, 7}, {0, 1, 2, 6, 8}, {0, 1, 3, 4, 7}, {0, 1, 3, 4, 8}, {0, 1, 4, 5, 7}, {0, 1, 3, 6, 7}, {0, 1, 3, 7, 8}, {0, 1, 4, 5, 8}, {0, 1, 4, 7, 8}, {0, 2, 3, 5, 7}, {0, 1, 3, 5, 7}, {0, 2, 3, 5, 8}, {0, 2, 4, 5, 8}, {0, 1, 3, 5, 8}, {0, 2, 3, 6, 8}, {0, 1, 3, 6, 8}, {0, 1, 4, 6, 8}, {0, 1, 3, 6, 9}, {0, 1, 4, 6, 9}, {0, 2, 4, 6, 8}, {0, 2, 4, 6, 9}, {0, 2, 4, 7, 9}, {0, 1, 2, 4, 7}, {0, 3, 4, 5, 8}, {0, 1, 2, 5, 8}, {0, 1, 2, 3, 4, 5}, {0, 1, 2, 3, 4, 6}, {0, 1, 2, 3, 5, 6}, {0, 1, 2, 4, 5, 6}, {0, 1, 2, 3, 6, 7}, {0, 1, 2, 5, 6, 7}, {0, 1, 2, 6, 7, 8}, {0, 2, 3, 4, 5, 7}, {0, 1, 2, 3, 5, 7}, {0, 1, 3, 4, 5, 7}, {0, 1, 2, 4, 5, 7}, {0, 1, 2, 4, 6, 7}, {0, 1, 3, 4, 6, 7}, {0, 1, 3, 4, 5, 8}, {0, 1, 2, 4, 5, 8}, {0, 1, 4, 5, 6, 8}, {0, 1, 2, 4, 7, 8}, {0, 1, 2, 5, 7, 8}, {0, 1, 3, 4, 7, 8}, {0, 1, 4, 5, 8, 9}, {0, 2, 3, 4, 6, 8}, {0, 1, 2, 4, 6, 8}, {0, 2, 3, 5, 6, 8}, {0, 1, 3, 4, 6, 8}, {0, 1, 3, 5, 6, 8}, {0, 1, 3, 5, 7, 8}, {0, 1, 3, 4, 6, 9}, {0, 1, 3, 5, 6, 9}, {0, 1, 3, 6, 8, 9}, {0, 1, 3, 6, 7, 9}, {0, 1, 3, 5, 8, 9}, {0, 2, 4, 5, 7, 9}, {0, 2, 3, 5, 7, 9}, {0, 1, 3, 5, 7, 9}, {0, 2, 4, 6, 8, 10}, {0, 1, 2, 3, 4, 7}, {0, 1, 2, 3, 4, 8}, {0, 1, 2, 3, 7, 8}, {0, 2, 3, 4, 5, 8}, {0, 1, 2, 3, 5, 8}, {0, 1, 2, 3, 6, 8}, {0, 1, 2, 3, 6, 9}, {0, 1, 2, 5, 6, 8}, {0, 1, 2, 5, 6, 9}, {0, 2, 3, 4, 6, 9}, {0, 1, 2, 4, 6, 9}, {0, 1, 2, 4, 7, 9}, {0, 1, 2, 5, 7, 9}, {0, 1, 3, 4, 7, 9}, {0, 1, 4, 6, 7, 9}, {0, 1, 2, 3, 4, 5, 6}, {0, 1, 2, 3, 4, 5, 7}, {0, 1, 2, 3, 4, 5, 8}, {0, 1, 2, 3, 4, 6, 7}, {0, 1, 2, 3, 5, 6, 7}, {0, 1, 2, 3, 4, 7, 8}, {0, 1, 2, 3, 6, 7, 8}, {0, 2, 3, 4, 5, 6, 8}, {0, 1, 2, 3, 4, 6, 8}, {0, 1, 2, 3, 4, 6, 9}, {0, 1, 3, 4, 5, 6, 8}, {0, 1, 2, 3, 4, 7, 9}, {0, 1, 2, 4, 5, 6, 8}, {0, 1, 2, 3, 5, 7, 8}, {0, 1, 2, 4, 6, 7, 8}, {0, 1, 2, 3, 5, 6, 9}, {0, 1, 2, 4, 5, 6, 9}, {0, 1, 2, 3, 5, 8, 9}, {0, 1, 2, 3, 6, 7, 9}, {0, 1, 2, 4, 7, 8, 9}, {0, 1, 2, 4, 5, 8, 9}, {0, 1, 2, 5, 6, 8, 9}, {0, 2, 3, 4, 5, 7, 9}, {0, 1, 2, 3, 5, 7, 9}, {0, 2, 3, 4, 6, 7, 9}, {0, 1, 3, 4, 5, 7, 9}, {0, 1, 2, 4, 5, 7, 9}, {0, 1, 3, 5, 6, 7, 9}, {0, 1, 2, 4, 6, 7, 9}, {0, 1, 2, 4, 6, 8, 9}, {0, 1, 3, 4, 6, 7, 9}, {0, 1, 3, 4, 6, 8, 9}, {0, 1, 2, 4, 6, 8, 10}, {0, 1, 3, 4, 6, 8, 10}, {0, 1, 3, 5, 6, 8, 10}, {0, 1, 2, 3, 5, 6, 8}, {0, 1, 3, 4, 5, 7, 8}, {0, 1, 2, 4, 5, 7, 8}, {0, 1, 2, 3, 4, 5, 6, 7}, {0, 1, 2, 3, 4, 5, 6, 8}, {0, 1, 2, 3, 4, 5, 6, 9}, {0, 1, 2, 3, 4, 5, 7, 8}, {0, 1, 2, 3, 4, 6, 7, 8}, {0, 1, 2, 3, 5, 6, 7, 8}, {0, 1, 2, 3, 4, 5, 8, 9}, {0, 1, 2, 3, 4, 7, 8, 9}, {0, 1, 2, 3, 6, 7, 8, 9}, {0, 2, 3, 4, 5, 6, 7, 9}, {0, 1, 2, 3, 4, 5, 7, 9}, {0, 1, 3, 4, 5, 6, 7, 9}, {0, 1, 2, 3, 4, 6, 7, 9}, {0, 1, 2, 4, 5, 6, 7, 9}, {0, 1, 2, 3, 4, 6, 8, 9}, {0, 1, 2, 3, 5, 7, 8, 9}, {0, 1, 3, 4, 5, 6, 8, 9}, {0, 1, 2, 3, 5, 6, 8, 9}, {0, 1, 2, 4, 5, 6, 8, 9}, {0, 1, 2, 4, 5, 7, 8, 9}, {0, 1, 2, 3, 4, 6, 8, 10}, {0, 1, 2, 3, 5, 6, 8, 10}, {0, 1, 2, 3, 5, 7, 8, 10}, {0, 1, 2, 4, 5, 6, 8, 10}, {0, 1, 2, 4, 6, 7, 8, 10}, {0, 1, 2, 4, 5, 7, 9, 10}, {0, 1, 2, 4, 5, 7, 8, 10}, {0, 1, 3, 4, 6, 7, 9, 10}, {0, 1, 2, 3, 5, 6, 7, 9}, {0, 1, 2, 3, 4, 5, 6, 7, 8}, {0, 1, 2, 3, 4, 5, 6, 7, 9}, {0, 1, 2, 3, 4, 5, 6, 8, 9}, {0, 1, 2, 3, 4, 5, 7, 8, 9}, {0, 1, 2, 3, 4, 6, 7, 8, 9}, {0, 1, 2, 3, 4, 5, 6, 8, 10}, {0, 1, 2, 3, 4, 5, 7, 8, 10}, {0, 1, 2, 3, 4, 6, 7, 8, 10}, {0, 1, 2, 3, 5, 6, 7, 8, 10}, {0, 1, 2, 3, 4, 6, 7, 9, 10}, {0, 1, 2, 3, 5, 6, 7, 9, 10}, {0, 1, 2, 4, 5, 6, 8, 9, 10}};
    private static final boolean[] z = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, true, true, false, true, false, false, false, true, true, true, true, false, false, false, true, false, true, false, false, false, true, true, true, true, false, true, true, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false};

    public static String claseInfo() {
        return "Clase PitchClassSet. version: 1.1 - Desarrollada por: Lic. Gustavo Garc\u00eda Novo. - Buenos Aires, octubre de 2006. ";
    }

    public PitchClassSet(int n, int n2) throws ArgumentoFueraDeRangoException {
        if (!PitchClassSet.verificarSetValido(n, n2)) {
            throw new ArgumentoFueraDeRangoException(n + "." + n2 + " no es un set v\u00e1lido.");
        }
        this.nElementosSet = n;
        this.setTipo = n2;
        this.notas = PitchClassSet.getFormaPrima(n, n2);
    }

    public PitchClassSet(int[] nArray) throws SetNoValidoException {
        if (!PitchClassSet.verificarSetValido(nArray)) {
            throw new SetNoValidoException("No es un set v\u00e1lido.");
        }
        this.notas = nArray;
        this.nElementosSet = nArray.length;
        this.setTipo = PitchClassSet.getSetTipo(nArray);
    }

    public PitchClassSet() {
    }

    public void setPcs(int n, int n2) throws ArgumentoFueraDeRangoException {
        if (!PitchClassSet.verificarSetValido(n, n2)) {
            throw new ArgumentoFueraDeRangoException(n + "." + n2 + " no es un set v\u00e1lido.");
        }
        this.nElementosSet = n;
        this.setTipo = n2;
        this.notas = PitchClassSet.getFormaPrima(n, n2);
    }

    public void setPcs(int[] nArray) throws SetNoValidoException {
        if (!PitchClassSet.verificarSetValido(nArray)) {
            System.err.print("set ");
            for (int i = 0; i < nArray.length; ++i) {
                System.err.print(nArray[i] + " ");
            }
            throw new SetNoValidoException();
        }
        this.notas = nArray;
    }

    public int[] getPcsMf() {
        return this.notas;
    }

    public int[] getPcs() {
        return PitchClassSet.midiToMod12(this.notas);
    }

    public String getClasificacion() {
        return Integer.toString(this.getNElementos()) + "." + Integer.toString(this.getSetTipo());
    }

    public static String getClasificacion(int[] nArray) throws SetNoValidoException {
        if (!PitchClassSet.verificarSetValido(nArray)) {
            throw new SetNoValidoException();
        }
        return Integer.toString(PitchClassSet.getNElementos(nArray)) + "." + Integer.toString(PitchClassSet.getSetTipo(nArray));
    }

    public static int getSetTipo(int[] nArray) throws SetNoValidoException {
        if (!PitchClassSet.verificarSetValido(nArray)) {
            throw new SetNoValidoException();
        }
        int n = nArray.length;
        int n2 = PitchClassSet.getIndiceDeCantidad(n);
        int n3 = PitchClassSet.getIndiceDeCantidad(n + 1);
        int[] nArray2 = new int[n];
        nArray2 = PitchClassSet.getFormaPrima(nArray);
        boolean bl = true;
        for (int i = n2; i < n3; ++i) {
            for (int j = 0; j < n; ++j) {
                if (fp[i][j] == nArray2[j]) continue;
                bl = false;
                break;
            }
            if (bl) {
                return i - n2 + 1;
            }
            bl = true;
        }
        System.out.println("El set ingresado no es v\u00e1lido.");
        return 0;
    }

    public static String getVectorIntervalico(int n, int n2) throws ArgumentoFueraDeRangoException {
        int n3;
        if (!PitchClassSet.verificarSetValido(n, n2)) {
            throw new ArgumentoFueraDeRangoException(n + "." + n2 + " no es un set v\u00e1lido.");
        }
        for (n3 = 0; n3 < arrayNElementos.length - 1 && (arrayNElementos[n3] != n || arraySetTipo[n3] != n2); ++n3) {
        }
        return vi[n3];
    }

    public static String getVectorIntervalico(int[] nArray) throws SetNoValidoException {
        if (!PitchClassSet.verificarSetValido(nArray)) {
            throw new SetNoValidoException();
        }
        int[] nArray2 = new int[nArray.length];
        nArray2 = PitchClassSet.getFormaPrima(nArray);
        return vi[PitchClassSet.getPcsIndice(nArray2)];
    }

    public String getVectorIntervalico() {
        int n;
        for (n = 0; n < arrayNElementos.length - 1 && (arrayNElementos[n] != this.nElementosSet || arraySetTipo[n] != this.setTipo); ++n) {
        }
        return vi[n];
    }

    public static int[] getFomaPrima(int n, int n2) throws ArgumentoFueraDeRangoException {
        int n3;
        if (!PitchClassSet.verificarSetValido(n, n2)) {
            throw new ArgumentoFueraDeRangoException(n + "." + n2 + " no es un set v\u00e1lido.");
        }
        for (n3 = 0; n3 < arrayNElementos.length - 1 && (arrayNElementos[n3] != n || arraySetTipo[n3] != n2); ++n3) {
        }
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = fp[n3][i];
        }
        return nArray;
    }

    public int[] getFomaPrima() {
        int n;
        for (n = 0; n < arrayNElementos.length - 1 && (arrayNElementos[n] != this.nElementosSet || arraySetTipo[n] != this.setTipo); ++n) {
        }
        int[] nArray = new int[this.nElementosSet];
        for (int i = 0; i < this.nElementosSet; ++i) {
            nArray[i] = fp[n][i];
        }
        return nArray;
    }

    public int getNElementos() {
        return this.nElementosSet;
    }

    public static int getNElementos(int[] nArray) {
        return nArray.length;
    }

    public int getSetTipo() {
        return this.setTipo;
    }

    public static boolean isInversion(int[] nArray) throws SetNoValidoException {
        if (!PitchClassSet.verificarSetValido(nArray)) {
            throw new SetNoValidoException();
        }
        int n = nArray.length;
        int[] nArray2 = new int[n];
        nArray2 = PitchClassSet.getOrdenNormal(nArray);
        int n2 = nArray2[0];
        for (int i = 0; i < n; ++i) {
            nArray2[i] = nArray2[i] - n2;
        }
        return !PitchClassSet.isFormaPrima(nArray2);
    }

    public static int getTransporte(int[] nArray) throws SetNoValidoException {
        if (!PitchClassSet.verificarSetValido(nArray)) {
            throw new SetNoValidoException();
        }
        int n = nArray.length;
        int[] nArray2 = new int[n];
        int n2 = 999;
        if (PitchClassSet.isInversion(nArray)) {
            int n3;
            nArray2 = PitchClassSet.getFormaPrima(nArray);
            nArray2 = PitchClassSet.getInversion(nArray2);
            int[] nArray3 = new int[n];
            nArray3 = PitchClassSet.getOrdenNormal(nArray);
            for (n3 = 0; n3 < n; ++n3) {
                if (nArray3[n3] <= 11) continue;
                int n4 = n3;
                nArray3[n4] = nArray3[n4] - 12;
            }
            for (n3 = 0; n3 < 12; ++n3) {
                if (PitchClassSet.isMismosElementos(nArray2, nArray3)) {
                    n2 = n3;
                    break;
                }
                for (int i = 0; i < n; ++i) {
                    nArray2[i] = nArray2[i] + 1;
                    if (nArray2[i] <= 11) continue;
                    int n5 = i;
                    nArray2[n5] = nArray2[n5] - 12;
                }
            }
        } else {
            nArray2 = PitchClassSet.getOrdenNormal(nArray);
            n2 = nArray2[0];
        }
        return n2;
    }

    public static int[] getTransporte(int[] nArray, int n) throws SetNoValidoException, ArgumentoFueraDeRangoException {
        if (!PitchClassSet.verificarSetValido(nArray)) {
            throw new SetNoValidoException();
        }
        int n2 = nArray.length;
        int[] nArray2 = new int[n2];
        if (n > 11 || n < 0) {
            throw new ArgumentoFueraDeRangoException("Transporte no v\u00e1lido (entre 0 y 11)");
        }
        nArray2 = PitchClassSet.getFormaPrima(nArray);
        for (int i = 0; i < n2; ++i) {
            nArray2[i] = nArray2[i] + n;
            if (nArray2[i] <= 11) continue;
            int n3 = i;
            nArray2[n3] = nArray2[n3] - 12;
        }
        return nArray2;
    }

    public int getTransporte() {
        int n = 0;
        try {
            n = PitchClassSet.getTransporte(this.notas);
        }
        catch (Exception exception) {
            System.err.println("Fallo interno.");
            exception.getMessage();
        }
        return n;
    }

    public static int[] getTransporte(int n, int n2, int n3) throws ArgumentoFueraDeRangoException {
        if (n3 < 0 || n3 > 11) {
            throw new ArgumentoFueraDeRangoException(n3 + " no es un transporte v\u00e1lido (entre 0 y 11)");
        }
        if (!PitchClassSet.verificarSetValido(n, n2)) {
            throw new ArgumentoFueraDeRangoException(n + "." + n2 + " no es un set v\u00e1lido.");
        }
        int[] nArray = new int[n];
        int[] nArray2 = nArray = PitchClassSet.getFormaPrima(n, n2);
        try {
            nArray2 = PitchClassSet.getTransporte(nArray, n3);
        }
        catch (SetNoValidoException setNoValidoException) {
            System.err.println("Fallo interno.");
            setNoValidoException.getMessage();
        }
        return nArray2;
    }

    public int[] getTransporte(int n) throws SetNoValidoException, ArgumentoFueraDeRangoException {
        if (n < 0 || n > 11) {
            throw new ArgumentoFueraDeRangoException(n + " no es un transporte v\u00e1lido (entre 0 y 11).");
        }
        int[] nArray = this.notas;
        try {
            nArray = PitchClassSet.getTransporte(this.notas, n);
        }
        catch (SetNoValidoException setNoValidoException) {
            System.err.println("Fallo interno.");
            setNoValidoException.getMessage();
        }
        return nArray;
    }

    public static boolean isZ(int[] nArray) throws SetNoValidoException {
        if (!PitchClassSet.verificarSetValido(nArray)) {
            throw new SetNoValidoException();
        }
        int[] nArray2 = new int[nArray.length];
        nArray2 = PitchClassSet.getFormaPrima(nArray);
        return z[PitchClassSet.getPcsIndice(nArray2)];
    }

    public boolean isZ() {
        boolean bl = false;
        try {
            bl = PitchClassSet.isZ(this.notas);
        }
        catch (SetNoValidoException setNoValidoException) {
            System.err.println("Fallo interno");
            setNoValidoException.getMessage();
        }
        return bl;
    }

    public static boolean isZ(int n, int n2) throws ArgumentoFueraDeRangoException, SetNoValidoException {
        if (!PitchClassSet.verificarSetValido(n, n2)) {
            throw new ArgumentoFueraDeRangoException(n + "." + n2 + " no es un set v\u00e1lido.");
        }
        int[] nArray = new int[n];
        nArray = PitchClassSet.getFormaPrima(n, n2);
        boolean bl = false;
        bl = z[PitchClassSet.getPcsIndice(nArray)];
        return bl;
    }

    public static int[] getZ(int[] nArray) throws SetNoValidoException {
        if (!PitchClassSet.verificarSetValido(nArray)) {
            throw new SetNoValidoException();
        }
        if (!PitchClassSet.isZ(nArray)) {
            throw new SetNoValidoException("No posee par Z.");
        }
        int[] nArray2 = new int[nArray.length];
        int n = z.length;
        String string = PitchClassSet.getVectorIntervalico(nArray);
        int n2 = PitchClassSet.getPcsIndice(nArray);
        for (int i = 0; i < n; ++i) {
            if (string != vi[i] || i == n2) continue;
            for (int j = 0; j < nArray.length; ++j) {
                nArray2[j] = fp[i][j];
            }
        }
        return nArray2;
    }

    public static int[] getZ(int n, int n2) throws SetNoValidoException, ArgumentoFueraDeRangoException {
        if (!PitchClassSet.verificarSetValido(n, n2)) {
            throw new SetNoValidoException();
        }
        return PitchClassSet.getZ(PitchClassSet.getFormaPrima(n, n2));
    }

    public int[] getZ() throws SetNoValidoException {
        return PitchClassSet.getZ(this.notas);
    }

    public static boolean verificarSetValido(int[] nArray) {
        int n;
        int n2 = nArray.length;
        int[] nArray2 = new int[n2];
        boolean bl = true;
        for (n = 0; n < n2; ++n) {
            if (nArray[n] >= 0 && nArray[n] <= 127) continue;
            bl = false;
            break;
        }
        if (bl) {
            if (n2 > 9 || n2 < 3) {
                bl = false;
            }
            nArray2 = PitchClassSet.midiToMod12(nArray);
            for (int i = 0; i < n2; ++i) {
                for (n = i + 1; n < n2; ++n) {
                    if (nArray2[i] != nArray2[n]) continue;
                    bl = false;
                }
            }
        }
        return bl;
    }

    private static int[] midiToMod12(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = nArray[i];
            while (nArray2[i] > 11) {
                nArray2[i] = nArray2[i] - 12;
            }
        }
        return nArray2;
    }

    private static int[] ordenarSet(int[] nArray) throws SetNoValidoException {
        if (!PitchClassSet.verificarSetValido(nArray)) {
            throw new SetNoValidoException();
        }
        int n = nArray.length;
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray2[i] = nArray[i];
        }
        for (int i = 1; i <= n - 1; ++i) {
            for (int j = 0; j <= n - 2; ++j) {
                if (nArray2[j] <= nArray2[j + 1]) continue;
                int n2 = nArray2[j];
                nArray2[j] = nArray2[j + 1];
                nArray2[j + 1] = n2;
            }
        }
        return nArray2;
    }

    private static int[][] permutacionCircular(int[] nArray) {
        int n;
        int n2 = nArray.length;
        int[][] nArray2 = new int[n2][n2];
        for (n = 0; n < n2; ++n) {
            nArray2[n][0] = nArray[n];
        }
        for (int i = 1; i < n2; ++i) {
            for (n = i; n < n2; ++n) {
                nArray2[n - i][i] = nArray[n];
            }
            int n3 = n - i;
            for (n = 0; n < i; ++n) {
                nArray2[n3][i] = nArray[n] + 12;
                ++n3;
            }
        }
        return nArray2;
    }

    private static boolean isMuchosMenores(int[] nArray, int n) {
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            ++n2;
        }
        return n2 > 1;
    }

    private static int getMenor(int[] nArray) {
        int n = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i] >= n) continue;
            n = nArray[i];
        }
        return n;
    }

    private static int[][] transportarAllSetsTablaAmismoPitch(int[][] nArray, int n) {
        int n2 = nArray.length;
        int[][] nArray2 = new int[n2][n2];
        for (int i = 0; i < n2; ++i) {
            int n3 = nArray[0][i];
            for (int j = 0; j < n2; ++j) {
                nArray2[j][i] = nArray[j][i] - n3 + n;
            }
        }
        return nArray2;
    }

    public static int[] getOrdenNormal(int[] nArray) throws SetNoValidoException {
        int n;
        int n2;
        int n3;
        int n4;
        if (!PitchClassSet.verificarSetValido(nArray)) {
            throw new SetNoValidoException();
        }
        int n5 = nArray.length;
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < n5; ++i) {
            nArray2[i] = nArray[i];
        }
        nArray2 = PitchClassSet.midiToMod12(nArray2);
        nArray2 = PitchClassSet.ordenarSet(nArray2);
        int[][] nArray3 = new int[n5][n5];
        nArray3 = PitchClassSet.permutacionCircular(nArray2);
        int[] nArray4 = new int[n5];
        for (n4 = 0; n4 < n5; ++n4) {
            nArray4[n4] = nArray3[n5 - 1][n4] - nArray3[0][n4];
        }
        n4 = PitchClassSet.getMenor(nArray4);
        for (n3 = 1; PitchClassSet.isMuchosMenores(nArray4, n4) && n3 < n5 - 1; ++n3) {
            for (n2 = 0; n2 < n5; ++n2) {
                nArray4[n2] = nArray4[n2] == n4 ? nArray3[n3][n2] - nArray3[0][n2] : 9999;
            }
            n4 = PitchClassSet.getMenor(nArray4);
        }
        for (n2 = 0; n2 < n5; ++n2) {
            if (nArray4[n2] != n4) continue;
            n3 = n2;
        }
        n2 = nArray3[0][n3];
        int[][] nArray5 = new int[n5][n5];
        nArray5 = PitchClassSet.transportarAllSetsTablaAmismoPitch(nArray3, n2);
        int n6 = n3;
        boolean bl = true;
        for (n = 0; n < n5; ++n) {
            for (int i = 0; i < n5; ++i) {
                if (nArray5[i][n] == nArray3[i][n3]) continue;
                bl = false;
            }
            if (!bl || n6 <= n) continue;
            n6 = n;
        }
        for (n = 0; n < n5; ++n) {
            nArray2[n] = nArray3[n][n6];
        }
        return nArray2;
    }

    private static int[] getInversionM12(int[] nArray) {
        int n = nArray.length;
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray2[i] = 12 - nArray[i];
            if (nArray2[i] != 12) continue;
            nArray2[i] = 0;
        }
        return nArray2;
    }

    public static int[] getInversion(int[] nArray) throws SetNoValidoException {
        if (!PitchClassSet.verificarSetValido(nArray)) {
            throw new SetNoValidoException();
        }
        int n = nArray.length;
        int[] nArray2 = new int[n];
        int n2 = 127 - 2 * nArray[0];
        for (int i = 0; i < n; ++i) {
            nArray2[i] = 127 - nArray[i] - n2;
            while (nArray2[i] < 0) {
                int n3 = i;
                nArray2[n3] = nArray2[n3] + 12;
            }
            while (nArray2[i] > 127) {
                int n4 = i;
                nArray2[n4] = nArray2[n4] - 12;
            }
        }
        return nArray2;
    }

    public int[] getInversion() {
        int n = this.nElementosSet;
        int[] nArray = new int[n];
        int n2 = 127 - 2 * this.notas[0];
        for (int i = 0; i < n; ++i) {
            nArray[i] = 127 - this.notas[i] - n2;
            while (nArray[i] < 0) {
                int n3 = i;
                nArray[n3] = nArray[n3] + 12;
            }
            while (nArray[i] > 127) {
                int n4 = i;
                nArray[n4] = nArray[n4] - 12;
            }
        }
        return nArray;
    }

    public static int[] getFormaPrima(int[] nArray) throws SetNoValidoException {
        int n;
        if (!PitchClassSet.verificarSetValido(nArray)) {
            throw new SetNoValidoException();
        }
        int n2 = nArray.length;
        int[] nArray2 = new int[n2];
        int[] nArray3 = new int[n2];
        nArray2 = PitchClassSet.getOrdenNormal(nArray);
        int n3 = nArray2[0];
        for (n = 0; n < n2; ++n) {
            nArray2[n] = nArray2[n] - n3;
        }
        if (!PitchClassSet.isFormaPrima(nArray2)) {
            nArray2 = PitchClassSet.getInversionM12(nArray2);
            nArray2 = PitchClassSet.getOrdenNormal(nArray2);
            n3 = nArray2[0];
            for (n = 0; n < n2; ++n) {
                nArray2[n] = nArray2[n] - n3;
            }
        }
        return nArray2;
    }

    public static int[] getFormaPrima(int n, int n2) throws ArgumentoFueraDeRangoException {
        if (!PitchClassSet.verificarSetValido(n, n2)) {
            throw new ArgumentoFueraDeRangoException(n + "." + n2 + " no es un set v\u00e1lido.");
        }
        int[] nArray = new int[n];
        if (PitchClassSet.verificarSetValido(n, n2)) {
            for (int i = 0; i < n; ++i) {
                nArray[i] = fp[PitchClassSet.getIndiceDeCantidad(n) + n2 - 1][i];
            }
        } else {
            System.err.println("Array no valido.");
        }
        return nArray;
    }

    public int[] getFormaPrima() throws ArgumentoFueraDeRangoException {
        int[] nArray = new int[this.nElementosSet];
        nArray = PitchClassSet.getFormaPrima(this.nElementosSet, this.setTipo);
        return nArray;
    }

    private static int getIndiceDeCantidad(int n) {
        int n2;
        switch (n) {
            case 3: {
                n2 = 0;
                break;
            }
            case 4: {
                n2 = 12;
                break;
            }
            case 5: {
                n2 = 41;
                break;
            }
            case 6: {
                n2 = 79;
                break;
            }
            case 7: {
                n2 = 129;
                break;
            }
            case 8: {
                n2 = 167;
                break;
            }
            case 9: {
                n2 = 196;
                break;
            }
            default: {
                n2 = 208;
            }
        }
        return n2;
    }

    private static int getPcsIndice(int[] nArray) throws SetNoValidoException {
        if (PitchClassSet.verificarSetValido(nArray)) {
            int n = nArray.length;
            int n2 = PitchClassSet.getIndiceDeCantidad(n);
            int n3 = PitchClassSet.getIndiceDeCantidad(n + 1);
            boolean bl = true;
            for (int i = n2; i < n3; ++i) {
                for (int j = 0; j < n; ++j) {
                    if (fp[i][j] == nArray[j]) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    return i;
                }
                bl = true;
            }
        }
        return 999;
    }

    private static boolean isFormaPrima(int[] nArray) {
        int n = nArray.length;
        int n2 = PitchClassSet.getIndiceDeCantidad(n);
        int n3 = PitchClassSet.getIndiceDeCantidad(n + 1);
        boolean bl = true;
        for (int i = n2; i < n3; ++i) {
            for (int j = 0; j < n; ++j) {
                if (fp[i][j] == nArray[j]) continue;
                bl = false;
                break;
            }
            if (bl) {
                return true;
            }
            bl = true;
        }
        return false;
    }

    private static boolean isMismosElementos(int[] nArray, int[] nArray2) throws SetNoValidoException {
        int n = nArray.length;
        boolean bl = true;
        int[] nArray3 = new int[n];
        int[] nArray4 = new int[n];
        nArray3 = PitchClassSet.ordenarSet(nArray);
        nArray4 = PitchClassSet.ordenarSet(nArray2);
        for (int i = 0; i < n; ++i) {
            if (nArray3[i] == nArray4[i]) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private static boolean verificarSetValido(int n, int n2) {
        switch (n) {
            case 3: {
                if (n2 <= 12 && n2 >= 1) break;
                return false;
            }
            case 4: {
                if (n2 <= 29 && n2 >= 1) break;
                return false;
            }
            case 5: {
                if (n2 <= 38 && n2 >= 1) break;
                return false;
            }
            case 6: {
                if (n2 <= 50 && n2 >= 1) break;
                return false;
            }
            case 7: {
                if (n2 <= 38 && n2 >= 1) break;
                return false;
            }
            case 8: {
                if (n2 <= 29 && n2 >= 1) break;
                return false;
            }
            case 9: {
                if (n2 <= 12 && n2 >= 1) break;
                return false;
            }
            default: {
                return false;
            }
        }
        return true;
    }
}

